<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateChargesTable extends Migration {

	public function up()
	{
		Schema::create('charges', function(Blueprint $table) {
			$table->increments('id');
			$table->string('content', 70)->nullable();
			$table->integer('dispatch_parking_id')->unsigned()->nullable();
			$table->integer('delivery_parking_id')->unsigned()->nullable();
			$table->float('quantity', 10,2);
			$table->integer('reference_cost_id')->unsigned()->nullable();
			$table->integer('generator_id')->unsigned();
			$table->integer('charge_type_id')->unsigned();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('charges');
	}
}