<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('transporters', function(Blueprint $table) {
			$table->foreign('truck_id')->references('id')->on('trucks')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('parking_zones', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('cities')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('charges', function(Blueprint $table) {
			$table->foreign('dispatch_parking_id')->references('id')->on('parking_zones')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('charges', function(Blueprint $table) {
			$table->foreign('delivery_parking_id')->references('id')->on('parking_zones')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('charges', function(Blueprint $table) {
			$table->foreign('reference_cost_id')->references('id')->on('reference_costs')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('charges', function(Blueprint $table) {
			$table->foreign('generator_id')->references('id')->on('generators')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('charges', function(Blueprint $table) {
			$table->foreign('charge_type_id')->references('id')->on('charge_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('trucks', function(Blueprint $table) {
			$table->foreign('transporter_id')->references('id')->on('transporters')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('trucks', function(Blueprint $table) {
			$table->foreign('axe_id')->references('id')->on('axes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('trucks', function(Blueprint $table) {
			$table->foreign('truck_uses_id')->references('id')->on('truck_uses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('trucks', function(Blueprint $table) {
			$table->foreign('state_id')->references('id')->on('states')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('trucks', function(Blueprint $table) {
			$table->foreign('truck_structure_id')->references('id')->on('truck_structures')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('ratings', function(Blueprint $table) {
			$table->foreign('driver_id')->references('id')->on('drivers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('ratings', function(Blueprint $table) {
			$table->foreign('truck_id')->references('id')->on('trucks')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('states', function(Blueprint $table) {
			$table->foreign('truck_id')->references('id')->on('trucks')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('offers', function(Blueprint $table) {
			$table->foreign('generador_id')->references('id')->on('generators')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('offers', function(Blueprint $table) {
			$table->foreign('charge_id')->references('id')->on('charges')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('offers', function(Blueprint $table) {
			$table->foreign('dispatch_parking_id')->references('id')->on('parking_zones')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('offers', function(Blueprint $table) {
			$table->foreign('delivery_parking_id')->references('id')->on('cities')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('offers', function(Blueprint $table) {
			$table->foreign('reference_cost_id')->references('id')->on('reference_costs')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('offers', function(Blueprint $table) {
			$table->foreign('transporter_id')->references('id')->on('transporters')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('reference_costs', function(Blueprint $table) {
			$table->foreign('city_origin_id')->references('id')->on('cities')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('offer_transporter', function(Blueprint $table) {
			$table->foreign('transporter_id')->references('id')->on('transporters')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('offer_transporter', function(Blueprint $table) {
			$table->foreign('offer_id')->references('id')->on('offers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('transporters', function(Blueprint $table) {
			$table->dropForeign('transporters_truck_id_foreign');
		});
		Schema::table('parking_zones', function(Blueprint $table) {
			$table->dropForeign('parking_zones_city_id_foreign');
		});
		Schema::table('charges', function(Blueprint $table) {
			$table->dropForeign('charges_dispatch_parking_id_foreign');
		});
		Schema::table('charges', function(Blueprint $table) {
			$table->dropForeign('charges_delivery_parking_id_foreign');
		});
		Schema::table('charges', function(Blueprint $table) {
			$table->dropForeign('charges_reference_cost_id_foreign');
		});
		Schema::table('charges', function(Blueprint $table) {
			$table->dropForeign('charges_generator_id_foreign');
		});
		Schema::table('charges', function(Blueprint $table) {
			$table->dropForeign('charges_charge_type_id_foreign');
		});
		Schema::table('trucks', function(Blueprint $table) {
			$table->dropForeign('trucks_transporter_id_foreign');
		});
		Schema::table('trucks', function(Blueprint $table) {
			$table->dropForeign('trucks_axe_id_foreign');
		});
		Schema::table('trucks', function(Blueprint $table) {
			$table->dropForeign('trucks_truck_uses_id_foreign');
		});
		Schema::table('trucks', function(Blueprint $table) {
			$table->dropForeign('trucks_state_id_foreign');
		});
		Schema::table('trucks', function(Blueprint $table) {
			$table->dropForeign('trucks_truck_structure_id_foreign');
		});
		Schema::table('ratings', function(Blueprint $table) {
			$table->dropForeign('ratings_driver_id_foreign');
		});
		Schema::table('ratings', function(Blueprint $table) {
			$table->dropForeign('ratings_truck_id_foreign');
		});
		Schema::table('states', function(Blueprint $table) {
			$table->dropForeign('states_truck_id_foreign');
		});
		Schema::table('offers', function(Blueprint $table) {
			$table->dropForeign('offers_generador_id_foreign');
		});
		Schema::table('offers', function(Blueprint $table) {
			$table->dropForeign('offers_charge_id_foreign');
		});
		Schema::table('offers', function(Blueprint $table) {
			$table->dropForeign('offers_dispatch_parking_id_foreign');
		});
		Schema::table('offers', function(Blueprint $table) {
			$table->dropForeign('offers_delivery_parking_id_foreign');
		});
		Schema::table('offers', function(Blueprint $table) {
			$table->dropForeign('offers_reference_cost_id_foreign');
		});
		Schema::table('offers', function(Blueprint $table) {
			$table->dropForeign('offers_transporter_id_foreign');
		});
		Schema::table('reference_costs', function(Blueprint $table) {
			$table->dropForeign('reference_costs_city_origin_id_foreign');
		});
		Schema::table('offer_transporter', function(Blueprint $table) {
			$table->dropForeign('offer_transporter_transporter_id_foreign');
		});
		Schema::table('offer_transporter', function(Blueprint $table) {
			$table->dropForeign('offer_transporter_offer_id_foreign');
		});
	}
}