<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Charge extends Eloquent {

	protected $table = 'charges';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('dispatch_parking_id', 'delivery_parking_id', 'quantity', 'reference_cost_id', 'generator_id');

	public function generatos()
	{
		return $this->belongsTo('App\Generator', 'charge_id');
	}

	public function trucks()
	{
		return $this->belongsToMany('App\Truck', 'truck_id');
	}

}