<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Ratings extends Eloquent {

	protected $table = 'ratings';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('star', 'comments', 'driver_id', 'truck_id');

	public function truck()
	{
		return $this->belongsTo('App\Truck', 'truck_id');
	}

	public function driver()
	{
		return $this->belongsTo('App\Driver', 'driver_id');
	}

}