<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('addresses', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('providers', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('cities')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('branches', function(Blueprint $table) {
			$table->foreign('provider_id')->references('id')->on('providers')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('timings', function(Blueprint $table) {
			$table->foreign('branch_id')->references('id')->on('branches')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('managers', function(Blueprint $table) {
			$table->foreign('branch_id')->references('id')->on('branches')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('cars', function(Blueprint $table) {
			$table->foreign('car_type_id')->references('id')->on('car_types')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('cars', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('cars', function(Blueprint $table) {
			$table->foreign('car_model_id')->references('id')->on('car_models')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('off_dates', function(Blueprint $table) {
			$table->foreign('car_id')->references('id')->on('cars')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Order', function(Blueprint $table) {
			$table->foreign('car_id')->references('id')->on('cars')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('Order', function(Blueprint $table) {
			$table->foreign('branch_id')->references('id')->on('branches')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('Order', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('addresses', function(Blueprint $table) {
			$table->dropForeign('addresses_user_id_foreign');
		});
		Schema::table('providers', function(Blueprint $table) {
			$table->dropForeign('providers_city_id_foreign');
		});
		Schema::table('branches', function(Blueprint $table) {
			$table->dropForeign('branches_provider_id_foreign');
		});
		Schema::table('timings', function(Blueprint $table) {
			$table->dropForeign('timings_branch_id_foreign');
		});
		Schema::table('managers', function(Blueprint $table) {
			$table->dropForeign('managers_branch_id_foreign');
		});
		Schema::table('cars', function(Blueprint $table) {
			$table->dropForeign('cars_car_type_id_foreign');
		});
		Schema::table('cars', function(Blueprint $table) {
			$table->dropForeign('cars_category_id_foreign');
		});
		Schema::table('cars', function(Blueprint $table) {
			$table->dropForeign('cars_car_model_id_foreign');
		});
		Schema::table('off_dates', function(Blueprint $table) {
			$table->dropForeign('off_dates_car_id_foreign');
		});
		Schema::table('Order', function(Blueprint $table) {
			$table->dropForeign('Order_car_id_foreign');
		});
		Schema::table('Order', function(Blueprint $table) {
			$table->dropForeign('Order_branch_id_foreign');
		});
		Schema::table('Order', function(Blueprint $table) {
			$table->dropForeign('Order_user_id_foreign');
		});
	}
}