<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('comentarios', function(Blueprint $table) {
			$table->foreign('usuario_id')->references('id')->on('usuarios')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('comentarios', function(Blueprint $table) {
			$table->foreign('libro_id')->references('id')->on('libros')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('listas', function(Blueprint $table) {
			$table->foreign('usuario_id')->references('id')->on('usuarios')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('reservas', function(Blueprint $table) {
			$table->foreign('usuario_id')->references('id')->on('usuarios')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('reservas', function(Blueprint $table) {
			$table->foreign('libro_id')->references('id')->on('libros')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('libro_autor', function(Blueprint $table) {
			$table->foreign('libro_id')->references('id')->on('libros')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('libro_autor', function(Blueprint $table) {
			$table->foreign('autor_id')->references('id')->on('autores')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('libro_categoria', function(Blueprint $table) {
			$table->foreign('libro_id')->references('id')->on('libros')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('libro_categoria', function(Blueprint $table) {
			$table->foreign('categoria_id')->references('id')->on('categorias')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('libro_usuario', function(Blueprint $table) {
			$table->foreign('libro_id')->references('id')->on('libros')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('libro_usuario', function(Blueprint $table) {
			$table->foreign('usuario_id')->references('id')->on('usuarios')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('estantes', function(Blueprint $table) {
			$table->foreign('usuario_id')->references('id')->on('usuarios')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('libro_lista', function(Blueprint $table) {
			$table->foreign('libro_id')->references('id')->on('libros')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('libro_lista', function(Blueprint $table) {
			$table->foreign('lista_id')->references('id')->on('listas')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('libro_estante', function(Blueprint $table) {
			$table->foreign('libro_id')->references('id')->on('libros')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('libro_estante', function(Blueprint $table) {
			$table->foreign('estante_id')->references('id')->on('estantes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('comentarios', function(Blueprint $table) {
			$table->dropForeign('comentarios_usuario_id_foreign');
		});
		Schema::table('comentarios', function(Blueprint $table) {
			$table->dropForeign('comentarios_libro_id_foreign');
		});
		Schema::table('listas', function(Blueprint $table) {
			$table->dropForeign('listas_usuario_id_foreign');
		});
		Schema::table('reservas', function(Blueprint $table) {
			$table->dropForeign('reservas_usuario_id_foreign');
		});
		Schema::table('reservas', function(Blueprint $table) {
			$table->dropForeign('reservas_libro_id_foreign');
		});
		Schema::table('libro_autor', function(Blueprint $table) {
			$table->dropForeign('libro_autor_libro_id_foreign');
		});
		Schema::table('libro_autor', function(Blueprint $table) {
			$table->dropForeign('libro_autor_autor_id_foreign');
		});
		Schema::table('libro_categoria', function(Blueprint $table) {
			$table->dropForeign('libro_categoria_libro_id_foreign');
		});
		Schema::table('libro_categoria', function(Blueprint $table) {
			$table->dropForeign('libro_categoria_categoria_id_foreign');
		});
		Schema::table('libro_usuario', function(Blueprint $table) {
			$table->dropForeign('libro_usuario_libro_id_foreign');
		});
		Schema::table('libro_usuario', function(Blueprint $table) {
			$table->dropForeign('libro_usuario_usuario_id_foreign');
		});
		Schema::table('estantes', function(Blueprint $table) {
			$table->dropForeign('estantes_usuario_id_foreign');
		});
		Schema::table('libro_lista', function(Blueprint $table) {
			$table->dropForeign('libro_lista_libro_id_foreign');
		});
		Schema::table('libro_lista', function(Blueprint $table) {
			$table->dropForeign('libro_lista_lista_id_foreign');
		});
		Schema::table('libro_estante', function(Blueprint $table) {
			$table->dropForeign('libro_estante_libro_id_foreign');
		});
		Schema::table('libro_estante', function(Blueprint $table) {
			$table->dropForeign('libro_estante_estante_id_foreign');
		});
	}
}