<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLibrosTable extends Migration {

	public function up()
	{
		Schema::create('libros', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->bigInteger('isbn');
			$table->string('titulo', 60);
			$table->integer('paginas')->unsigned();
			$table->decimal('precio');
			$table->decimal('puntaje');
			$table->decimal('puntajec');
			$table->text('descripcion');
			$table->boolean('stock');
			$table->boolean('activo');
			$table->integer('score');
		});
	}

	public function down()
	{
		Schema::drop('libros');
	}
}