<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSmartScalesTable extends Migration {

	public function up()
	{
		Schema::create('Smart_scales', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('profile_id')->unsigned();
			$table->integer('user_id')->unsigned();
			$table->text('user');
			$table->string('ageOfBody', 10);
			$table->text('ageOfBodyRange');
			$table->string('bmi', 32);
			$table->text('bmiRange');
			$table->text('bmiWHORange');
			$table->string('bmr', 10);
			$table->text('bmrRange');
			$table->string('bodyShape', 10);
			$table->string('desirableWeight', 32);
			$table->string('fatFreeBodyWeight', 32);
			$table->string('fatToControl', 32);
			$table->string('levelOfVisceralFat', 32);
			$table->text('levelOfVisceralFatRange');
			$table->string('idealWeight', 32);
			$table->string('obesityLevel', 32);
			$table->text('rateOfBurnFat');
			$table->string('ratioOfFat', 32);
			$table->string('ratioOfMuscle', 32);
			$table->text('ratioOfFatRange');
			$table->text('ratioOfMuscleRange');
			$table->string('ratioOfWater', 32);
			$table->text('ratioOfWaterRange');
			$table->datetime('created_at');
			$table->datetime('updated_at');
		});
	}

	public function down()
	{
		Schema::drop('Smart_scales');
	}
}