<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('Health_profiles', function(Blueprint $table) {
			$table->foreign('account_id')->references('id')->on('Accounts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Smart_scales', function(Blueprint $table) {
			$table->foreign('profile_id')->references('id')->on('Health_profiles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Smart_scales', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('Accounts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Heights', function(Blueprint $table) {
			$table->foreign('profile_id')->references('id')->on('Health_profiles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Heights', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('Accounts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Heights', function(Blueprint $table) {
			$table->foreign('device_id')->references('id')->on('Devices')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Medical_histories', function(Blueprint $table) {
			$table->foreign('profile_id')->references('id')->on('Health_profiles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Medical_histories', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('Accounts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Heartbeats', function(Blueprint $table) {
			$table->foreign('profile_id')->references('id')->on('Health_profiles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Heartbeats', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('Accounts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Heartbeats', function(Blueprint $table) {
			$table->foreign('device_id')->references('id')->on('Devices')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Temperatures', function(Blueprint $table) {
			$table->foreign('profile_id')->references('id')->on('Health_profiles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Temperatures', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('Accounts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Temperatures', function(Blueprint $table) {
			$table->foreign('device_id')->references('id')->on('Devices')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Blood_pressures', function(Blueprint $table) {
			$table->foreign('profile_id')->references('id')->on('Health_profiles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Blood_pressures', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('Accounts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Blood_pressures', function(Blueprint $table) {
			$table->foreign('device_id')->references('id')->on('Devices')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Files', function(Blueprint $table) {
			$table->foreign('profile_id')->references('id')->on('Health_profiles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Files', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('Accounts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Users', function(Blueprint $table) {
			$table->foreign('service_id')->references('id')->on('Services')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Services', function(Blueprint $table) {
			$table->foreign('admin')->references('id')->on('Users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Services', function(Blueprint $table) {
			$table->foreign('payment_account_id')->references('id')->on('Payment_accounts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Chat_rooms', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('Accounts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Chat_messages', function(Blueprint $table) {
			$table->foreign('account_id')->references('id')->on('Accounts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Chat_messages', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('Users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Chat_messages', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('Categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Chat_messages', function(Blueprint $table) {
			$table->foreign('room_id')->references('id')->on('Chat_rooms')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Articles', function(Blueprint $table) {
			$table->foreign('service_id')->references('id')->on('Services')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Articles', function(Blueprint $table) {
			$table->foreign('created_by')->references('id')->on('Users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Articles', function(Blueprint $table) {
			$table->foreign('confirmed_by')->references('id')->on('Users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Articles', function(Blueprint $table) {
			$table->foreign('published_by')->references('id')->on('Users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Article_tag', function(Blueprint $table) {
			$table->foreign('article_id')->references('id')->on('Articles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Article_tag', function(Blueprint $table) {
			$table->foreign('tag_id')->references('id')->on('Tags')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Role_Permission', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('Roles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Role_Permission', function(Blueprint $table) {
			$table->foreign('permission_id')->references('id')->on('Permissions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('User_role', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('Users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('User_role', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('Roles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Article_category', function(Blueprint $table) {
			$table->foreign('article_id')->references('id')->on('Articles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Article_category', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('Categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Article_right', function(Blueprint $table) {
			$table->foreign('article_id')->references('id')->on('Articles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('Health_profiles', function(Blueprint $table) {
			$table->dropForeign('Health_profiles_account_id_foreign');
		});
		Schema::table('Smart_scales', function(Blueprint $table) {
			$table->dropForeign('Smart_scales_profile_id_foreign');
		});
		Schema::table('Smart_scales', function(Blueprint $table) {
			$table->dropForeign('Smart_scales_user_id_foreign');
		});
		Schema::table('Heights', function(Blueprint $table) {
			$table->dropForeign('Heights_profile_id_foreign');
		});
		Schema::table('Heights', function(Blueprint $table) {
			$table->dropForeign('Heights_user_id_foreign');
		});
		Schema::table('Heights', function(Blueprint $table) {
			$table->dropForeign('Heights_device_id_foreign');
		});
		Schema::table('Medical_histories', function(Blueprint $table) {
			$table->dropForeign('Medical_histories_profile_id_foreign');
		});
		Schema::table('Medical_histories', function(Blueprint $table) {
			$table->dropForeign('Medical_histories_user_id_foreign');
		});
		Schema::table('Heartbeats', function(Blueprint $table) {
			$table->dropForeign('Heartbeats_profile_id_foreign');
		});
		Schema::table('Heartbeats', function(Blueprint $table) {
			$table->dropForeign('Heartbeats_user_id_foreign');
		});
		Schema::table('Heartbeats', function(Blueprint $table) {
			$table->dropForeign('Heartbeats_device_id_foreign');
		});
		Schema::table('Temperatures', function(Blueprint $table) {
			$table->dropForeign('Temperatures_profile_id_foreign');
		});
		Schema::table('Temperatures', function(Blueprint $table) {
			$table->dropForeign('Temperatures_user_id_foreign');
		});
		Schema::table('Temperatures', function(Blueprint $table) {
			$table->dropForeign('Temperatures_device_id_foreign');
		});
		Schema::table('Blood_pressures', function(Blueprint $table) {
			$table->dropForeign('Blood_pressures_profile_id_foreign');
		});
		Schema::table('Blood_pressures', function(Blueprint $table) {
			$table->dropForeign('Blood_pressures_user_id_foreign');
		});
		Schema::table('Blood_pressures', function(Blueprint $table) {
			$table->dropForeign('Blood_pressures_device_id_foreign');
		});
		Schema::table('Files', function(Blueprint $table) {
			$table->dropForeign('Files_profile_id_foreign');
		});
		Schema::table('Files', function(Blueprint $table) {
			$table->dropForeign('Files_user_id_foreign');
		});
		Schema::table('Users', function(Blueprint $table) {
			$table->dropForeign('Users_service_id_foreign');
		});
		Schema::table('Services', function(Blueprint $table) {
			$table->dropForeign('Services_admin_foreign');
		});
		Schema::table('Services', function(Blueprint $table) {
			$table->dropForeign('Services_payment_account_id_foreign');
		});
		Schema::table('Chat_rooms', function(Blueprint $table) {
			$table->dropForeign('Chat_rooms_user_id_foreign');
		});
		Schema::table('Chat_messages', function(Blueprint $table) {
			$table->dropForeign('Chat_messages_account_id_foreign');
		});
		Schema::table('Chat_messages', function(Blueprint $table) {
			$table->dropForeign('Chat_messages_user_id_foreign');
		});
		Schema::table('Chat_messages', function(Blueprint $table) {
			$table->dropForeign('Chat_messages_category_id_foreign');
		});
		Schema::table('Chat_messages', function(Blueprint $table) {
			$table->dropForeign('Chat_messages_room_id_foreign');
		});
		Schema::table('Articles', function(Blueprint $table) {
			$table->dropForeign('Articles_service_id_foreign');
		});
		Schema::table('Articles', function(Blueprint $table) {
			$table->dropForeign('Articles_created_by_foreign');
		});
		Schema::table('Articles', function(Blueprint $table) {
			$table->dropForeign('Articles_confirmed_by_foreign');
		});
		Schema::table('Articles', function(Blueprint $table) {
			$table->dropForeign('Articles_published_by_foreign');
		});
		Schema::table('Article_tag', function(Blueprint $table) {
			$table->dropForeign('Article_tag_article_id_foreign');
		});
		Schema::table('Article_tag', function(Blueprint $table) {
			$table->dropForeign('Article_tag_tag_id_foreign');
		});
		Schema::table('Role_Permission', function(Blueprint $table) {
			$table->dropForeign('Role_Permission_role_id_foreign');
		});
		Schema::table('Role_Permission', function(Blueprint $table) {
			$table->dropForeign('Role_Permission_permission_id_foreign');
		});
		Schema::table('User_role', function(Blueprint $table) {
			$table->dropForeign('User_role_user_id_foreign');
		});
		Schema::table('User_role', function(Blueprint $table) {
			$table->dropForeign('User_role_role_id_foreign');
		});
		Schema::table('Article_category', function(Blueprint $table) {
			$table->dropForeign('Article_category_article_id_foreign');
		});
		Schema::table('Article_category', function(Blueprint $table) {
			$table->dropForeign('Article_category_category_id_foreign');
		});
		Schema::table('Article_right', function(Blueprint $table) {
			$table->dropForeign('Article_right_article_id_foreign');
		});
	}
}