<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateArticlesTable extends Migration {

	public function up()
	{
		Schema::create('Articles', function(Blueprint $table) {
			$table->increments('id');
			$table->string('title', 255);
			$table->string('image', 255);
			$table->string('description', 255);
			$table->text('content');
			$table->integer('status');
			$table->string('type', 10);
			$table->integer('service_id')->unsigned();
			$table->integer('created_by')->unsigned();
			$table->integer('confirmed_by')->unsigned();
			$table->datetime('confirmed_at');
			$table->integer('published_by')->unsigned();
			$table->datetime('published_at');
			$table->datetime('deleted_at');
			$table->datetime('created_at');
			$table->datetime('updated_at');
		});
	}

	public function down()
	{
		Schema::drop('Articles');
	}
}