<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('categoryCompetition', function(Blueprint $table) {
			$table->foreign('competition_id')->references('id')->on('competitions')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('categoryCompetition', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('homologations', function(Blueprint $table) {
			$table->foreign('competition_id')->references('id')->on('competitions')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('homologations', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('homologations', function(Blueprint $table) {
			$table->foreign('robot_id')->references('id')->on('robots')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('robots', function(Blueprint $table) {
			$table->foreign('team_id')->references('id')->on('teams')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('teams', function(Blueprint $table) {
			$table->foreign('responsable_id')->references('id')->on('members')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('teams', function(Blueprint $table) {
			$table->foreign('captain_id')->references('id')->on('members')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('members', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('members', function(Blueprint $table) {
			$table->foreign('team_id')->references('id')->on('teams')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('competitionRobot', function(Blueprint $table) {
			$table->foreign('competition_id')->references('id')->on('competitions')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('competitionRobot', function(Blueprint $table) {
			$table->foreign('robot_id')->references('id')->on('robots')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('categoryRobot', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('categoryRobot', function(Blueprint $table) {
			$table->foreign('robot_id')->references('id')->on('robots')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('battle', function(Blueprint $table) {
			$table->foreign('id_robot_1')->references('id')->on('robots')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('battle', function(Blueprint $table) {
			$table->foreign('id_robot_2')->references('id')->on('robots')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('battle', function(Blueprint $table) {
			$table->foreign('ganador')->references('id')->on('robots')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('battle', function(Blueprint $table) {
			$table->foreign('categoria_id')->references('id')->on('categories')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('categoryCompetition', function(Blueprint $table) {
			$table->dropForeign('categoryCompetition_competition_id_foreign');
		});
		Schema::table('categoryCompetition', function(Blueprint $table) {
			$table->dropForeign('categoryCompetition_category_id_foreign');
		});
		Schema::table('homologations', function(Blueprint $table) {
			$table->dropForeign('homologations_competition_id_foreign');
		});
		Schema::table('homologations', function(Blueprint $table) {
			$table->dropForeign('homologations_category_id_foreign');
		});
		Schema::table('homologations', function(Blueprint $table) {
			$table->dropForeign('homologations_robot_id_foreign');
		});
		Schema::table('robots', function(Blueprint $table) {
			$table->dropForeign('robots_team_id_foreign');
		});
		Schema::table('teams', function(Blueprint $table) {
			$table->dropForeign('teams_responsable_id_foreign');
		});
		Schema::table('teams', function(Blueprint $table) {
			$table->dropForeign('teams_captain_id_foreign');
		});
		Schema::table('members', function(Blueprint $table) {
			$table->dropForeign('members_user_id_foreign');
		});
		Schema::table('members', function(Blueprint $table) {
			$table->dropForeign('members_team_id_foreign');
		});
		Schema::table('competitionRobot', function(Blueprint $table) {
			$table->dropForeign('competitionRobot_competition_id_foreign');
		});
		Schema::table('competitionRobot', function(Blueprint $table) {
			$table->dropForeign('competitionRobot_robot_id_foreign');
		});
		Schema::table('categoryRobot', function(Blueprint $table) {
			$table->dropForeign('categoryRobot_category_id_foreign');
		});
		Schema::table('categoryRobot', function(Blueprint $table) {
			$table->dropForeign('categoryRobot_robot_id_foreign');
		});
		Schema::table('battle', function(Blueprint $table) {
			$table->dropForeign('battle_id_robot_1_foreign');
		});
		Schema::table('battle', function(Blueprint $table) {
			$table->dropForeign('battle_id_robot_2_foreign');
		});
		Schema::table('battle', function(Blueprint $table) {
			$table->dropForeign('battle_ganador_foreign');
		});
		Schema::table('battle', function(Blueprint $table) {
			$table->dropForeign('battle_categoria_id_foreign');
		});
	}
}