<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAddressesTable extends Migration {

	public function up()
	{
		Schema::create('addresses', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->integer('country_id');
			$table->string('street', 254);
			$table->string('city', 254);
			$table->string('zipcode', 6);
			$table->string('additional', 254);
		});
	}

	public function down()
	{
		Schema::drop('addresses');
	}
}