<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProfileTable extends Migration {

	public function up()
	{
		Schema::create('profile', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->string('firstname', 255);
			$table->string('lastname', 255);
			$table->date('birthdate');
			$table->text('about');
			$table->string('image', 255);
			$table->string('facebook', 254);
		});
	}

	public function down()
	{
		Schema::drop('profile');
	}
}