<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->uuid('uuid', 32)->unique();
			$table->string('name', 191);
			$table->string('email', 191)->unique();
			$table->string('password', 191);
			$table->string('address', 191)->nullable();
			$table->string('ext_phone', 16)->nullable();
			$table->timestamps();
			$table->string('int_phone', 16)->nullable();
			$table->rememberToken('remember_token');
			$table->integer('status')->nullable()->default('0');
			$table->timestamps();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}