<?php

namespace App\Models;

class City extends Eloquent {

	protected $table = 'cities';
	public $timestamps = true;
	protected $fillable = array('county_id', 'name');

	public function user()
	{
		return $this->hasMany('App\Models\User', 'user_id');
	}

	public function county()
	{
		return $this->belongsTo('App\Models\County', 'county_id');
	}

}