<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('Document', function(Blueprint $table) {
			$table->foreign('id_Module')->references('id')->on('Module')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('Document', function(Blueprint $table) {
			$table->foreign('id_User')->references('id')->on('User')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('Type', function(Blueprint $table) {
			$table->foreign('id_Doc')->references('id')->on('Document')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('Filiere_Annee_User', function(Blueprint $table) {
			$table->foreign('id_Annee')->references('id')->on('AnneeScolaire')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('Filiere_Annee_User', function(Blueprint $table) {
			$table->foreign('id_Filiere')->references('id')->on('Filiere')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('Filiere_Annee_User', function(Blueprint $table) {
			$table->foreign('id_User')->references('id')->on('User')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('Document', function(Blueprint $table) {
			$table->dropForeign('Document_id_Module_foreign');
		});
		Schema::table('Document', function(Blueprint $table) {
			$table->dropForeign('Document_id_User_foreign');
		});
		Schema::table('Type', function(Blueprint $table) {
			$table->dropForeign('Type_id_Doc_foreign');
		});
		Schema::table('Filiere_Annee_User', function(Blueprint $table) {
			$table->dropForeign('Filiere_Annee_User_id_Annee_foreign');
		});
		Schema::table('Filiere_Annee_User', function(Blueprint $table) {
			$table->dropForeign('Filiere_Annee_User_id_Filiere_foreign');
		});
		Schema::table('Filiere_Annee_User', function(Blueprint $table) {
			$table->dropForeign('Filiere_Annee_User_id_User_foreign');
		});
	}
}