<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInvoiceLineOriginalsTable extends Migration {

	public function up()
	{
		Schema::create('invoice_line_originals', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('Invoice_id')->unsigned();
			$table->string('BSN', 20);
			$table->string('EmployeeName', 255);
			$table->string('Kind', 50);
			$table->date('PeriodFrom');
			$table->date('PeriodTo');
			$table->float('Amount');
			$table->float('WE');
			$table->float('WA');
			$table->float('WAO');
			$table->float('WGA');
			$table->float('ZVW');
			$table->float('TotalAmount');
			$table->integer('ImportedBy_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('invoice_line_originals');
	}
}