<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class ThreeDigit extends Eloquent {

	protected $table = 'three_digits';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('digits', 'primary_amount', 'secondary_amount', 'user_id');

	public function threeDigitsUser()
	{
		return $this->hasOne('User', 'user_id');
	}

}