<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('area_id', 'name', 'user_name', 'password', 'phone', 'cash_balance', 'winning_balance', 'user_type');

	public function userArea()
	{
		return $this->belongsTo('Area', 'area_id');
	}

}