<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFireTrucksTable extends Migration {

	public function up()
	{
		Schema::create('fire_trucks', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('numberplate', 15)->unique();
			$table->integer('fire_station_id')->unsigned()->nullable();
			$table->integer('fire_type_id')->unsigned();
			$table->decimal('latitude', 2,6);
			$table->decimal('longitude', 2,6);
		});
	}

	public function down()
	{
		Schema::drop('fire_trucks');
	}
}