<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProjectsTable extends Migration {

	public function up()
	{
		Schema::create('projects', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->text('title');
			$table->text('description');
			$table->string('github_link', 255)->nullable();
			$table->string('website_link', 255)->nullable();
			$table->tinyInteger('public')->default('1');
			$table->string('image', 255)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('projects');
	}
}