<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('warehouse', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->foreign('subcategory_id')->references('id')->on('categories')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('warehouse_products', function(Blueprint $table) {
			$table->foreign('warehouse_id')->references('id')->on('warehouse')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('warehouse_products', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('warehouse_products', function(Blueprint $table) {
			$table->foreign('product_variant_map_id')->references('id')->on('product_variants_map')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('variant_values', function(Blueprint $table) {
			$table->foreign('variant_id')->references('id')->on('variants')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('product_variants_map', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('product_variants_map', function(Blueprint $table) {
			$table->foreign('unit_id')->references('id')->on('units')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('warehouse', function(Blueprint $table) {
			$table->dropForeign('warehouse_user_id_foreign');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->dropForeign('products_category_id_foreign');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->dropForeign('products_subcategory_id_foreign');
		});
		Schema::table('warehouse_products', function(Blueprint $table) {
			$table->dropForeign('warehouse_products_warehouse_id_foreign');
		});
		Schema::table('warehouse_products', function(Blueprint $table) {
			$table->dropForeign('warehouse_products_product_id_foreign');
		});
		Schema::table('warehouse_products', function(Blueprint $table) {
			$table->dropForeign('warehouse_products_product_variant_map_id_foreign');
		});
		Schema::table('variant_values', function(Blueprint $table) {
			$table->dropForeign('variant_values_variant_id_foreign');
		});
		Schema::table('product_variants_map', function(Blueprint $table) {
			$table->dropForeign('product_variants_map_product_id_foreign');
		});
		Schema::table('product_variants_map', function(Blueprint $table) {
			$table->dropForeign('product_variants_map_unit_id_foreign');
		});
	}
}