<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class WarehouseProductsModel extends Eloquent {

	protected $table = 'warehouse_products';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function warehouse()
	{
		return $this->belongsTo('App\WarehouseModel', 'warehouse_id');
	}

	public function product()
	{
		return $this->belongsTo('App\ProductsModel', 'product_id');
	}

	public function productVariant()
	{
		return $this->belongsTo('App\ProductVariantsMapModel', 'product_variant_map_id');
	}

}