<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('products', function(Blueprint $table) {
			$table->increments('id');
			$table->string('product_name');
			$table->longText('description')->nullable();
			$table->integer('category_id')->unsigned()->index();
			$table->integer('subcategory_id')->unsigned()->index();
			$table->string('image')->nullable();
			$table->enum('status', array('Active', 'Inactive'));
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('products');
	}
}