<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCartOrdersTable extends Migration {

	public function up()
	{
		Schema::create('cart_orders', function(Blueprint $table) {
			$table->increments('id');
			$table->string('order_num');
			$table->integer('user_id')->unsigned();
			$table->integer('coupon_id')->unsigned();
			$table->integer('address_id')->unsigned();
			$table->decimal('sub_total', 10,2);
			$table->decimal('vat', 10,2);
			$table->decimal('discount', 10,2);
			$table->decimal('total', 10,2);
			$table->text('description')->nullable();
			$table->string('status');
			$table->timestamps();
			$table->decimal('shipping_price', 10,2);
			$table->string('cancel_reason')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('cart_orders');
	}
}