<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrderOffersTable extends Migration {

	public function up()
	{
		Schema::create('order_offers', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('order_id');
			$table->bigInteger('provider_id');
			$table->enum('status', array('1:pending', '2:accepted', '3:rejected'));
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('order_offers');
	}
}