<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('avatar', 50)->nullable();
			$table->string('name', 50);
			$table->string('country_code', 5)->default('966');
			$table->string('phone', 15);
			$table->string('email')->nullable();
			$table->string('password');
			$table->decimal('lat', 10, 8)->nullable();
			$table->decimal('lng', 10, 8)->nullable();
			$table->string('map_desc', 255)->nullable();
			$table->boolean('is_active')->default(0);
			$table->boolean('is_blocked')->default(0);
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}