<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductGroupsTable extends Migration {

	public function up()
	{
		Schema::create('product_groups', function(Blueprint $table) {
			$table->increments('id');
			$table->boolean('base_group')->default(0);
			$table->string('product_id');
			$table->decimal('price');
			$table->integer('quantity');
			$table->enum('discount_type', array(''));
			$table->decimal('discount_value', 10, 8);
			$table->timestamp('started_discount_at');
			$table->timestamp('ended_discount_at');
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('product_groups');
	}
}