<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateServiceRequestOffersTable extends Migration {

	public function up()
	{
		Schema::create('service_request_offers', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('service_request_id');
			$table->bigInteger('provider_id');
			$table->bigInteger('user_id');
			$table->enum('status', array('1:pending', '2:accepted', '3:rejected'));
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('service_request_offers');
	}
}