<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name')->nullable();
			$table->string('phone')->nullable();
			$table->string('country_key')->nullable();
			$table->string('code')->nullable();
			$table->boolean('is_active')->default(0);
			$table->string('email')->nullable();
			$table->integer('city_id')->unsigned();
			$table->boolean('is_notify')->nullable()->default(1);
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}