<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOfferTable extends Migration {

	public function up()
	{
		Schema::create('offer', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('priority')->nullable();
			$table->string('name_en')->nullable();
			$table->string('name_ar')->nullable();
			$table->text('details_en')->nullable();
			$table->text('details_ar')->nullable();
			$table->datetime('start_at')->nullable();
			$table->datetime('expire_at')->nullable();
			$table->double('price')->nullable();
			$table->integer('clinic_id')->nullable();
			$table->integer('specialty_id')->nullable();
			$table->integer('city_id')->nullable();
			$table->double('longitude')->nullable();
			$table->double('latitude')->nullable();
			$table->integer('clicks')->nullable();
			$table->integer('uses')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('offer');
	}
}