<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Message extends Model 
{

    protected $table = 'message';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('from_user', 'to_user', 'type', 'message', 'ad_id');

    public function from_user()
    {
        return $this->belongsTo('User', 'from_user');
    }

    public function to_user()
    {
        return $this->belongsTo('User', 'to_user');
    }

    public function ad()
    {
        return $this->belongsTo('Ad', 'ad_id');
    }

}