<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class PostHashtag extends Model 
{

    protected $table = 'post_hashtag';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('post_id', 'hashtag_id');

    public function post()
    {
        return $this->belongsTo('Post', 'post_id');
    }

}