<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAdTable extends Migration {

	public function up()
	{
		Schema::create('ad', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('seller_id')->nullable();
			$table->integer('category_id')->nullable();
			$table->string('status')->nullable();
			$table->datetime('expire_at')->nullable();
			$table->boolean('guarantee')->nullable()->default(0);
			$table->double('price')->nullable();
			$table->text('details')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('ad');
	}
}