<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMessageTable extends Migration {

	public function up()
	{
		Schema::create('message', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('from_user')->nullable();
			$table->integer('to_user')->nullable();
			$table->string('type')->nullable();
			$table->longText('message')->nullable();
			$table->integer('ad_id')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('message');
	}
}