<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class CommentReaction extends Eloquent {

	protected $table = 'comment_reaction';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('comment_id', 'reaction_id', 'created_by');

	public function comment()
	{
		return $this->belongsTo('Comment', 'comment_id');
	}

	public function reaction()
	{
		return $this->belongsTo('Reaction', 'reaction_id');
	}

	public function client()
	{
		return $this->belongsTo('User', 'created_by');
	}

}