<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Fav extends Eloquent {

	protected $table = 'fav';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('ad_id', 'user_id', 'list_id');

	public function ad()
	{
		return $this->belongsTo('Ad', 'ad_id');
	}

	public function user()
	{
		return $this->belongsTo('User', 'user_id');
	}

	public function list()
	{
		return $this->belongsTo('FavList', 'list_id');
	}

}