<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class FavList extends Eloquent {

	protected $table = 'fav_list';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('user_id', 'title');

	public function user()
	{
		return $this->belongsTo('User', 'user_id');
	}

	public function favs()
	{
		return $this->hasMany('Fav', 'list_id');
	}

}