<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Tag extends Eloquent {

	protected $table = 'tag';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name_en', 'name_ar', 'type_id', 'category_id');

	public function category()
	{
		return $this->belongsTo('Category', 'category_id');
	}

	public function type()
	{
		return $this->belongsTo('TagType', 'type_id');
	}

}