<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AdType extends Model 
{

    protected $table = 'ad_type';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('ad_id', 'type_id');

    public function ad()
    {
        return $this->belongsTo('Ad', 'ad_id');
    }

    public function type()
    {
        return $this->belongsTo('TagType', 'type_id');
    }

}