<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Post extends Model 
{

    protected $table = 'post';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('title_en', 'title_ar', 'details_en', 'details_ar', 'total_views');

    public function hashtags()
    {
        return $this->belongsToMany('Hashtag', 'post_hashtag', 'post_id', 'hashtag_id');
    }

    public function reactions()
    {
        return $this->hasMany('PostReaction', 'post_id');
    }

    public function comments()
    {
        return $this->hasMany('Comment', 'post_id');
    }

}