<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'user';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'phone', 'email', 'password', 'country_id', 'city_id');

    public function country()
    {
        return $this->belongsTo('Country', 'country_id');
    }

    public function city()
    {
        return $this->belongsTo('City', 'city_id');
    }

    public function adds()
    {
        return $this->belongsToMany('Ad', 'add_seller', 'seller_id', 'add_id');
    }

}