<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInvoicesTable extends Migration {

	public function up()
	{
		Schema::create('invoices', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('order_id')->unsigned();
			$table->timestamps();
			$table->string('invoice_no');
			$table->timestamp('invoice_date');
			$table->timestamp('due_date');
			$table->enum('status', array('open', 'closed', 'cancelled'));
		});
	}

	public function down()
	{
		Schema::drop('invoices');
	}
}