<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTblCompanyTable extends Migration {

	public function up()
	{
		Schema::create('tbl_company', function(Blueprint $table) {
			$table->increments('company_id', true);
			$table->string('company_name', 100);
			$table->string('company_address', 100)->nullable();
			$table->string('company_address_2', 100)->nullable();
			$table->string('company_postcode', 45)->nullable();
			$table->integer('city_id')->unsigned();
			$table->integer('city_port_id')->unsigned();
			$table->timestamp('company_created');
			$table->timestamp('company_deleted')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('tbl_company');
	}
}