<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTblFleetOwnershipTransferTable extends Migration {

	public function up()
	{
		Schema::create('tbl_fleet_ownership_transfer', function(Blueprint $table) {
			$table->increments('fleet_ownership_transfer_id', true);
			$table->integer('fleet_id')->unsigned();
			$table->integer('user_id_old')->unsigned();
			$table->integer('user_id_new')->unsigned();
			$table->enum('fleet_ownership_transfer_status', array('Invited', 'Accepted', 'Declined', 'Expired'));
			$table->timestamp('fleet_ownership_transfer_created');
			$table->timestamp('fleet_ownership_transfer_expired')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('tbl_fleet_ownership_transfer');
	}
}