<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTblFleetTable extends Migration {

	public function up()
	{
		Schema::create('tbl_fleet', function(Blueprint $table) {
			$table->increments('fleet_id', true);
			$table->string('fleet_title', 100);
			$table->text('fleet_description')->nullable();
			$table->text('fleet_remark')->nullable();
			$table->integer('owner_id')->unsigned();
			$table->integer('user_id')->unsigned();
			$table->datetime('fleet_created');
			$table->datetime('fleet_updated');
			$table->datetime('fleet_deleted')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('tbl_fleet');
	}
}