<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTblSettingEquipmentTable extends Migration {

	public function up()
	{
		Schema::create('tbl_setting_equipment', function(Blueprint $table) {
			$table->increments('equipment_id');
			$table->integer('equipment_type_id')->unsigned();
			$table->string('equipment_name', 100);
			$table->text('equipment_description')->nullable();
			$table->enum('equipment_format', array(''));
			$table->tinyInteger('is_required_value')->default('0');
			$table->tinyInteger('is_quantity')->default('1');
			$table->json('equipment_properties')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('tbl_setting_equipment');
	}
}