<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTblSettingEquipmentTypeTable extends Migration {

	public function up()
	{
		Schema::create('tbl_setting_equipment_type', function(Blueprint $table) {
			$table->increments('equipment_type_id', true);
			$table->integer('equipment_type_priority');
			$table->integer('equipment_category_id')->unsigned();
			$table->string('equipment_type_name', 100);
			$table->text('equipment_type_description')->nullable();
			$table->text('equipment_type_remark')->nullable();
			$table->enum('equipment_type_status', array('Active', 'Inactive'));
			$table->datetime('equipment_type_created');
			$table->datetime('equipment_type_updated');
			$table->datetime('equipment_type_deleted')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('tbl_setting_equipment_type');
	}
}