<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTblSettingFormTable extends Migration {

	public function up()
	{
		Schema::create('tbl_setting_form', function(Blueprint $table) {
			$table->increments('form_id', true);
			$table->string('form_name', 100);
			$table->text('form_description')->nullable();
			$table->enum('form_status', array('active', 'inactive'));
			$table->timestamp('form_created');
			$table->timestamp('form_updated');
			$table->timestamp('form_deleted')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('tbl_setting_form');
	}
}