<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTblUserTable extends Migration {

	public function up()
	{
		Schema::create('tbl_user', function(Blueprint $table) {
			$table->increments('user_id', true);
			$table->string('user_mobile_country_code', 10);
			$table->string('user_mobile', 45);
			$table->string('password');
			$table->string('user_email', 100)->nullable();
			$table->enum('user_type_slug', array('superadmin', 'admin', 'user'));
			$table->enum('user_status', array('Active', 'Pending', 'Suspend'));
			$table->datetime('otp_verified')->nullable();
			$table->datetime('user_logindate')->nullable();
			$table->string('user_ip', 39)->nullable();
			$table->integer('company_id')->unsigned();
			$table->datetime('user_created');
			$table->datetime('user_updated');
			$table->datetime('user_deleted')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('tbl_user');
	}
}